**Use this for data masking purposes for on-premise clients.**

***Steps:***

1. Extract the content of the zip file \[orangehrm-data-masking-pack.zip\]. It will contain two files mask-data.phar and config.json.
2. Change the values in the "local" section of the config.json file according to your MySQL settings.
3. Run the data masking using this command:

   `php mask-data.php database_name save_path code_base_path use_default_common_key [configuration-file-abs-path]`

   _Example:_ `php mask-data.phar prod_orangehrm /home/john/ /var/www/html/OHRMStandalone/TEST/716vas 1 /home/john/config.json`

If you encounter pre-requisite check failures, correct the values in the config.json file in both "local" and "system" sections and retry. 

---

**Entering Special Characters in** `mysql-root-password`

When editing the configuration file (`config.json`), some special characters must be **escaped** so that PHP can read the JSON correctly.

**How to Escape Special Characters:**

In JSON, **a backslash (`\`) is used for escaping**. This means:

- To include a backslash → write **`\\`**
- To include double quotes → write **`\"`**

**Common Characters You Must Escape:**

```
" (double quote)    \"
\ (backslash)       \\
```


***Examples:***

Password you want: **My"Pa\ssword**  


**How to write it in `config.json`:**
```json
{
  "mysql-root-password": "My\\\"Pa\\ssword"
}
```
